/** @file   glyph.h
 * @brief   Declaraction of Glyph - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_GLYPH_H
#define H_ENG2D_GLYPH_H

#include <allegro.h>
#include "eng2d_dll.h"

namespace eng2d {

/** @class  Glyph
 * @brief   Manages the data of a single character.
 * @author  Tomi Lamminsaari
 *
 * Glyph represents a single character. It manages the graphics data as well
 * as the size information of a character. The @c GlyphSet - class contains
 * the set of these Glyph - objects that form the characterset of this font.
 */
class DLLIMPORT Glyph
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  
  

  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	Glyph();


	/** Destructor
   */
	virtual ~Glyph();


private:

	/** Copy constructor.
   * @param     rO                Reference to another Glyph
   */
  Glyph( const Glyph& rO );

	/** Assignment operator
   * @param     rO                Reference to another Glyph
   * @return    Reference to us.
   */
  Glyph& operator = ( const Glyph& rO );

public:


  ///
  /// Methods
  /// =======



  ///
  /// Getter methods
  /// ==============
  
  /** Returns the ASCII - code of the character this Glyph represents.
   * @return    The ASCII - code of the character.
   */
  int character() const;
  
  /** Returns the width of this character in pixels.
   * @return    The width of this character.
   */
  int width() const;
  
  /** Returns the pointer to the bitmap containing the graphics of this
   * character.
   * @return    Pointer to the character graphics.
   */
  BITMAP* gfx() const;


protected:

  friend class GlyphSet;
  
  /** Constructor
   */
  Glyph( int index, int c, int w );
  
  /** Sets the graphics
   */
  void setGfx( BITMAP* pB );
  
  

  ///
  /// Members
  /// =======

  /** The ascii-code of the character this glyph represents. */
  int m_character;
  
  /** The index of this glyph inside the font-file. This is for internal
   * purposes only and actually needed only when creating the graphics
   * of this glyph.
   */
  int m_index;
  
  /** Width of this glyph in pixels. */
  int m_width;
  
  /** Pointer to bitmap holding the glyph graphics */
  BITMAP* m_pGfx;
  


private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif
